<?php

$maxImageSize = setting('_general.max_image_size');

return [
    'id'        => 'featured-mentors',
    'name'      => __('Featured mentors'),
    'icon'      => '<i class="icon-briefcase"></i>',
    'tab'       => 'Common',
    'fields'    => [
        [ 
            'id'            => 'select_verient',
            'type'          => 'select',
            'class'         => '',
            'label_title'   => __('Select mentors verient'),
            'options'       => [
                'am-tutors-varient-one'        => 'Tutors Style 1',
                'am-tutors-varient-two'        => 'Tutors Style 2',
                'am-tutors-varient-three'      => 'Tutors Style 3',
                'am-tutors-varient-four'       => 'Tutors Style 4',
                'am-tutors-varient-five'       => 'Tutors Style 5',
            ],
            'default'       => '',  
            'placeholder'   => __('settings.select_from_list'),  
        ],
        [
            'id'            => 'bg_color_verient',
            'type'          => 'select',
            'class'         => '',
            'label_title'   => __('Select background color'),
            'options'       => [
                ''                               => 'Select Background Color',
                'am-featured-mentors-two'        => 'Background 1',
            ],
            'default'       => 'Select Background Color',  
        ],
        [
            'id'            => 'pre_heading_text_color',
            'type'          => 'colorpicker',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre heading text color'),
            // 'field_desc'    => __('settings.pre_heading_text_color_desc'),
        ],
        [
            'id'            => 'pre_heading_bg_color',
            'type'          => 'colorpicker',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre heading bg color'),
            // 'field_desc'    => __('settings.pre_heading_text_color_desc'),
        ],
        [
            'id'            => 'pre_heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre Heading'),
            'placeholder'   => __('Enter pre heading'),
        ],
        [
            'id'            => 'heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Heading'),
            'placeholder'   => __('Enter heading'),
        ],
        [
            'id'            => 'paragraph',
            'type'          => 'editor',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Description'),
            'placeholder'   => __('Enter description'),
        ],
        [
            'id'            => 'explore_mentors_btn_url',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Primary button url'),
            'placeholder'   => __('Enter url'),
        ],
        [
            'id'            => 'explore_mentors_btn_text',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Primary button text'),
            'placeholder'   => __('Enter button text'),
        ],
        [
            'id'            => 'view_tutor_btn_url',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Profile button url'),
            'placeholder'   => __('Enter url'),
        ],
        [
            'id'            => 'view_tutor_btn_text',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Profile button text'),
            'placeholder'   => __('Enter button text'),
        ],
        [
            'id'            => 'left_shape_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('Left shape image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,            
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ], 
        ],
        [
            'id'            => 'right_shape_image',
            'type'          => 'file',
            'class'         => '',
            'label_title'   => __('Right shape image'),
            'label_desc'    => __('Add image'),
            'max_size'      => $maxImageSize ?? 5,            
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ], 
        ],
    ]
];
